import numpy as np
from keras.preprocessing import image
from keras.applications import inception_v3
from keras.models import load_model
# Load pre-trained image recognition model
# model = inception_v3.InceptionV3()
model = load_model('lenet.h5')
class_names = ['airplane', 'automobile', 'bird', 'cat', 'deer', 'dog', 'frog', 'horse', 'ship', 'truck']
# Load the image file and convert it to a numpy array
# img = image.load_img("cat.png", target_size=(299, 299))
img = image.load_img("5.jpg", target_size=(32, 32))
input_image = image.img_to_array(img)
# Scale the image so all pixel intensities are between [-1, 1] as the model expects
input_image /= 255.
input_image -= 0.5
input_image *= 2.
# Add a 4th dimension for batch size (as Keras expects)
input_image = np.expand_dims(input_image, axis=0)
# Run the image through the neural network
predictions = model.predict(input_image, batch_size=128)[0]
# Convert the predictions into text and print them
predicted_classes = np.argmax(predictions)
# predicted_classes = inception_v3.decode_predictions(predictions, top=1)
# imagenet_id, name, confidence = predicted_classes[0][0]
# print("This is a {} with {:.4}% confidence!".format(name, confidence * 100))
# print(predictions)
# print(predicted_classes)
print("This is a {} with {:.4}% confidence!".format(class_names[predicted_classes], predictions[predicted_classes] * 100))